/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler.async;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.sampler.ThreadDumper;
import me.lucko.spark.common.sampler.async.AsyncDataAggregator;
import me.lucko.spark.common.sampler.async.AsyncProfilerAccess;
import me.lucko.spark.common.sampler.async.JfrParsingException;
import me.lucko.spark.common.sampler.async.ProfileSegment;
import me.lucko.spark.common.sampler.async.jfr.JfrReader;
import me.lucko.spark.lib.asyncprofiler.AsyncProfiler;

public class AsyncProfilerJob {
    private static final AtomicReference<AsyncProfilerJob> ACTIVE = new AtomicReference();
    private final AsyncProfilerAccess access;
    private final AsyncProfiler profiler;
    private SparkPlatform platform;
    private int interval;
    private ThreadDumper threadDumper;
    private int window;
    private Path outputFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AsyncProfilerJob createNew(AsyncProfilerAccess access, AsyncProfiler profiler) {
        AtomicReference<AsyncProfilerJob> atomicReference = ACTIVE;
        synchronized (atomicReference) {
            AsyncProfilerJob existing = ACTIVE.get();
            if (existing != null) {
                throw new IllegalStateException("Another profiler is already active: " + existing);
            }
            AsyncProfilerJob job = new AsyncProfilerJob(access, profiler);
            ACTIVE.set(job);
            return job;
        }
    }

    private AsyncProfilerJob(AsyncProfilerAccess access, AsyncProfiler profiler) {
        this.access = access;
        this.profiler = profiler;
    }

    private String execute(String command) {
        try {
            return this.profiler.execute(command);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception whilst executing profiler command", e);
        }
    }

    private void checkActive() {
        if (ACTIVE.get() != this) {
            throw new IllegalStateException("Profiler job no longer active!");
        }
    }

    public void init(SparkPlatform platform, int interval, ThreadDumper threadDumper, int window) {
        this.platform = platform;
        this.interval = interval;
        this.threadDumper = threadDumper;
        this.window = window;
    }

    public void start() {
        this.checkActive();
        try {
            String resp;
            try {
                this.outputFile = this.platform.getTemporaryFiles().create("spark-", "-profile-data.jfr.tmp");
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create temporary output file", e);
            }
            String command = "start,event=" + (Object)((Object)this.access.getProfilingEvent()) + ",interval=" + this.interval + "us,threads,jfr,file=" + this.outputFile.toString();
            if (this.threadDumper instanceof ThreadDumper.Specific) {
                command = command + ",filter";
            }
            if (!(resp = this.execute(command).trim()).equalsIgnoreCase("profiling started")) {
                throw new RuntimeException("Unexpected response: " + resp);
            }
            if (this.threadDumper instanceof ThreadDumper.Specific) {
                ThreadDumper.Specific threadDumper = (ThreadDumper.Specific)this.threadDumper;
                for (Thread thread : threadDumper.getThreads()) {
                    this.profiler.addThread(thread);
                }
            }
        }
        catch (Exception e) {
            try {
                this.profiler.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.close();
            throw e;
        }
    }

    public void stop() {
        this.checkActive();
        try {
            this.profiler.stop();
        }
        catch (IllegalStateException e) {
            if (!e.getMessage().equals("Profiler is not active")) {
                throw e;
            }
        }
        finally {
            this.close();
        }
    }

    public void aggregate(AsyncDataAggregator dataAggregator) {
        Predicate<String> threadFilter;
        if (this.threadDumper instanceof ThreadDumper.Specific) {
            ThreadDumper.Specific specificDumper = (ThreadDumper.Specific)this.threadDumper;
            threadFilter = n -> specificDumper.getThreadNames().contains(n.toLowerCase());
        } else {
            threadFilter = n -> true;
        }
        try (JfrReader reader = new JfrReader(this.outputFile);){
            this.readSegments(reader, threadFilter, dataAggregator, this.window);
        }
        catch (Exception e) {
            boolean fileExists;
            try {
                fileExists = Files.exists(this.outputFile, new LinkOption[0]) && Files.size(this.outputFile) != 0L;
            }
            catch (IOException ex) {
                fileExists = false;
            }
            if (fileExists) {
                throw new JfrParsingException("Error parsing JFR data from profiler output", e);
            }
            throw new JfrParsingException("Error parsing JFR data from profiler output - file " + this.outputFile + " does not exist!", e);
        }
        try {
            Files.deleteIfExists(this.outputFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readSegments(JfrReader reader, Predicate<String> threadFilter, AsyncDataAggregator dataAggregator, int window) throws IOException {
        List<JfrReader.ExecutionSample> samples = reader.readAllEvents(JfrReader.ExecutionSample.class);
        for (int i = 0; i < samples.size(); ++i) {
            JfrReader.ExecutionSample sample = samples.get(i);
            long duration = i == 0 ? (long)this.interval : TimeUnit.NANOSECONDS.toMicros(sample.time - samples.get((int)(i - 1)).time);
            String threadName = reader.threads.get(sample.tid);
            if (!threadFilter.test(threadName)) continue;
            ProfileSegment segment = ProfileSegment.parseSegment(reader, sample, threadName, duration);
            dataAggregator.insertData(segment, window);
        }
    }

    public int getWindow() {
        return this.window;
    }

    private void close() {
        ACTIVE.compareAndSet(this, null);
    }
}

